﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Threading;

using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Runtime.Hosting;
using System.Workflow.ComponentModel;
 
using System.Workflow.Runtime.Tracking;
using System.Data.SqlClient;

/*  
    Tracking services
 
    TrackingService
    SqlTrackingService
    SqlTrackingWorkflowInstance
    TrackingProfile
 
    This example uses the predefined SqlTrackingService tracking service which stores
    tracking information to a MS SQL server database.
 
    For this application to work properly, 
    a local MS SQL server database must created. Use the sql scripts
        Tracking_Schema.sql and
        Tracking_Logic.sql
    found at <%WINDIR%>\Microsoft.NET\Framework\v3.0\Windows Workflow Foundation\SQL
    to create the database schema and stored procedures. Name the database WorkflowStore.
 
    This example can filter the recorded tracking information using a TrackingProfile
    if the "Filtered" check box is checked.
 
 */
namespace Lessons.Workflows
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }


        delegate void InfoDelegate(string Text);
        delegate void WorkflowDoneDelegate();
        delegate void TrackingInfoDelegate(Guid instanceId);

        string ConString = @"Data Source=localhost; Initial Catalog=WorkflowStore;Integrated Security=True;";

        WorkflowRuntime workflowRuntime = null;
        SqlTrackingService trackingService = null;



        /* adds the Text to the ListBox in a synchronized manner */
        public void ProcessInfo(string Text)
        {
            if (this.InvokeRequired)
            {
                /* if synchronization is required, then re-call itself through an invoked delegate */
                InfoDelegate d = delegate(string s) { ProcessInfo(s); };
                this.Invoke(d, Text);
            }
            else
            {
                this.lboInfo.Items.Add(Text);
            }  
        }

        

        /* arrange the user interface upon workflow termination, in a synchronized manner */
        private void WorkflowDone()
        {
            if (this.InvokeRequired)
            {
                WorkflowDoneDelegate d = delegate() { WorkflowDone(); };
                this.Invoke(d);
            }
            else
            {
                btnStartWorkflow.Enabled = true;
                lboInfo.Items.Add("-----------");
            }
        }
                


        /* creates a TrackingProfile and updates the MS SQL database using the UpdateTrackingProfile 
           in order for the tracking service to filter the recorded tracking information */
        void FilterTrackingInfo()
        {
            try
            {
                TrackingProfile profile = new TrackingProfile();
                profile.Version = new Version("1.0.0");

                /* ActivityTrackingLocation defines the activities and their events we want to track */
                ActivityTrackingLocation atl = new ActivityTrackingLocation(typeof(Activity));
                atl.MatchDerivedTypes = true;
                atl.ExecutionStatusEvents.Add(ActivityExecutionStatus.Executing);

                /* ActivityTrackPoint defines a activity related point of interest in the potential execution path of a workflow */
                ActivityTrackPoint atp = new ActivityTrackPoint();
                atp.MatchingLocations.Add(atl);
                profile.ActivityTrackPoints.Add(atp);

                /* WorkflowTrackPoint defines a workflow related point of interest in the potential execution path of a workflow */
                WorkflowTrackPoint wtp = new WorkflowTrackPoint();

                Array events = Enum.GetValues(typeof(TrackingWorkflowEvent));
                foreach (TrackingWorkflowEvent ev in events)
                    wtp.MatchingLocation.Events.Add(ev);

                profile.WorkflowTrackPoints.Add(wtp);

                StringWriter SW = new StringWriter(new StringBuilder());
                TrackingProfileSerializer serializer = new TrackingProfileSerializer();
                serializer.Serialize(SW, profile);


                using (SqlConnection Con = new SqlConnection(ConString))
                {

                    SqlCommand Cmd = new SqlCommand();
                    Cmd.Connection = Con;
                    Cmd.CommandType = CommandType.StoredProcedure;
                    Cmd.CommandText = "dbo.UpdateTrackingProfile";

                    Cmd.Parameters.Add(new SqlParameter("@TypeFullName", typeof(Lessons.Workflows.Workflow1).ToString()));
                    Cmd.Parameters.Add(new SqlParameter("@AssemblyFullName", typeof(Lessons.Workflows.Workflow1).Assembly.FullName));
                    Cmd.Parameters.Add(new SqlParameter("@Version", "1.0.0"));
                    Cmd.Parameters.Add(new SqlParameter("@TrackingProfileXml", SW.ToString()));

                    Con.Open();
                    Cmd.ExecuteNonQuery();
                }
            }
            catch (Exception ex)
            {
                lboInfo.Items.Add("ERROR: " + ex.Message);
            }

        }


        /* queries the MS SQL database using a SqlTrackingQuery object and displays the 
           the retrieved tracking infomation to the ListBox */
        void DisplayTrackingInfo(Guid instanceId)
        {
            if (this.InvokeRequired)
            {
                TrackingInfoDelegate d = delegate(Guid Id) { DisplayTrackingInfo(Id); };
                this.Invoke(d, instanceId);
            }
            else
            {
                SqlTrackingQuery q = new SqlTrackingQuery(ConString); 

                SqlTrackingWorkflowInstance stwi;
                q.TryGetWorkflow(instanceId, out stwi);

                if (stwi != null)
                {
                    lboInfo.Items.Add(string.Format("Tracking information for {0}", instanceId)); 

                    lboInfo.Items.Add("Workflow events ===============================");
                    foreach (WorkflowTrackingRecord wtr in stwi.WorkflowEvents)
                        lboInfo.Items.Add(string.Format("({0})   Status: {1}", wtr.EventDateTime, wtr.TrackingWorkflowEvent));


                    lboInfo.Items.Add("Activity events ===============================");
                    foreach (ActivityTrackingRecord atr in stwi.ActivityEvents)
                        lboInfo.Items.Add(string.Format("({0})   Activity: {1}   Status: {2}", atr.EventDateTime, atr.QualifiedName, atr.ExecutionStatus));
                }

            }
        }
         

        private void MainForm_Load(object sender, EventArgs e)
        { 
            workflowRuntime = new WorkflowRuntime();
 
            workflowRuntime.WorkflowCompleted += new EventHandler<WorkflowCompletedEventArgs>(WorkflowCompleted);
            workflowRuntime.WorkflowTerminated += new EventHandler<WorkflowTerminatedEventArgs>(WorkflowTerminated);
 
            ExternalDataExchangeService ExchangeService = new ExternalDataExchangeService();
            workflowRuntime.AddService(ExchangeService);
            WorkflowInfo workflowInfo = new WorkflowInfo(this);
            ExchangeService.AddService(workflowInfo);
        }

        void WorkflowCompleted(object sender, WorkflowCompletedEventArgs e)
        {
            WorkflowDone();

            /* since execution is done, display the recorded tracking information for the workflow instance */
            DisplayTrackingInfo(e.WorkflowInstance.InstanceId);
        }

        void WorkflowTerminated(object sender, WorkflowTerminatedEventArgs e)
        {
            WorkflowDone();
        }

        private void btnStartWorkflow_Click(object sender, EventArgs e)
        {
            lboInfo.Items.Clear();

            btnStartWorkflow.Enabled = false;


            /* stop the workflow runtime and remove the tracking service  */
            if (trackingService != null)
            {
                workflowRuntime.StopRuntime();
                workflowRuntime.RemoveService(trackingService);
            }

            /* empty the TrackingProfile table in the tracking MS SQL database  */
            using (SqlConnection Con = new SqlConnection(ConString))
            {
                SqlCommand Cmd = new SqlCommand();
                Cmd.Connection = Con;

                Cmd.CommandText = "delete from TrackingProfile";
                Con.Open();

                Cmd.ExecuteNonQuery();
            }

            /* add a tracking service again in order to have a chance to configure the TrackingProfile */
            trackingService = new SqlTrackingService(ConString);
            workflowRuntime.AddService(trackingService);

            /* add the TrackingProfile */
            if (chFiltered.Checked)
                FilterTrackingInfo();

            /* start the workflow */
            WorkflowInstance instance = workflowRuntime.CreateWorkflow(typeof(Lessons.Workflows.Workflow1));
            instance.Start();
        }


        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            workflowRuntime.Dispose();
        }


    }
}





namespace Lessons.Workflows
{

    /* a class implementing the contract interface. Only one implementation is allowed */
    public class WorkflowInfo : IWorkflowInfo
    {
        MainForm form;

        public WorkflowInfo(MainForm Form)
        {
            form = Form;
        }

        public void InformHost(string Text)
        {
            string S = " - ThreadID: " + Thread.CurrentThread.ManagedThreadId.ToString();
            form.ProcessInfo(Text + S);
        }
    }

}